#!/bin/sh

DPLY_PAGE_NAT_NETWORK_CONF_RESULT_MSG=""
DPLY_PAGE_NAT_NETWORK_CONF_RESULT_OK=0
DPLY_PAGE_NAT_NETWORK_CONF_RESULT_ERROR=1

DPLY_PAGE_NAT_NETWORK_CONF_RESULT_CODE=${DPLY_PAGE_NAT_NETWORK_CONF_RESULT_ERROR}
DPLY_PAGE_NAT_NETWORK_CONF_RESULT_ROLLING=0

dply_page_nat_network_conf() {
    debug_print "in function '${FUNCNAME[0]}'"

    # assign default value
    [ -z "${RT_NAT_IP}" ]      && RT_NAT_IP="${conf_nat_ip}"
    [ -z "${RT_NAT_NETMASK}" ] && RT_NAT_NETMASK="${conf_nat_netmask}"
    [ -z "${RT_NAT_DNS}" ]     && RT_NAT_DNS="${conf_nat_dns}"
    [ -z "${RT_NAT_GATEWAY}" ] && RT_NAT_GATEWAY="${conf_nat_gateway}"
    
    
	tp_network_conf \
		"${DPLY_PAGE_NAT_NETWORK_CONF_TITLE}" \
		"${DPLY_PAGE_NAT_NETWORK_CONF_TEXT}" \
		"${DPLY_PAGE_NAT_NETWORK_CONF_LABEL_OK}" \
		"${DPLY_PAGE_NAT_NETWORK_CONF_LABEL_CANCEL}" \
        "${RT_NAT_IP}" \
        "${RT_NAT_NETMASK}" \
        "${RT_NAT_GATEWAY}" \
        "${RT_NAT_DNS}"    
        
        
    debug_print "TP_NETWORK_CONF_RESULT_CODE: ${TP_NETWORK_CONF_RESULT_CODE}"
    case "${TP_NETWORK_CONF_RESULT_CODE}" in
    
        "${TP_NETWORK_CONF_RESULT_ERROR}")
            DPLY_PAGE_NAT_NETWORK_CONF_RESULT_CODE=$DPLY_PAGE_NAT_NETWORK_CONF_RESULT_ERROR
            DPLY_PAGE_NAT_NETWORK_CONF_RESULT_ROLLING=0
            DPLY_PAGE_NAT_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_RESULT_MSG}"
            return
            ;;
        
        "${TP_NETWORK_CONF_RESULT_CANCEL}")
            DPLY_PAGE_NAT_NETWORK_CONF_RESULT_CODE=$DPLY_PAGE_NAT_NETWORK_CONF_RESULT_OK
            DPLY_PAGE_NAT_NETWORK_CONF_RESULT_ROLLING=-1
            DPLY_PAGE_NAT_NETWORK_CONF_RESULT_MSG=""
            return
            ;;
            
        "${TP_NETWORK_CONF_RESULT_OK}" )
            ;;
        
        *)
            DPLY_PAGE_NAT_NETWORK_CONF_RESULT_CODE=$DPLY_PAGE_NAT_NETWORK_CONF_RESULT_ERROR
            DPLY_PAGE_NAT_NETWORK_CONF_RESULT_ROLLING=0
            DPLY_PAGE_NAT_NETWORK_CONF_RESULT_MSG="${DPLY_PAGE_NAT_NETWORK_CONF_ERROR_UNKNOWN}"
            return
            ;;
    esac
    
    
    # apply and error handling
    utility_apply_nat_network_conf \
        "${RT_NAT_DHCP}" \
        "${TP_NETWORK_CONF_RESULT_IP}" \
        "${TP_NETWORK_CONF_RESULT_NETMASK}" \
        "${TP_NETWORK_CONF_RESULT_GATEWAY}" \
        "${TP_NETWORK_CONF_RESULT_DNS}"
    if [ "${?}" -ne 0 ]; then
        DPLY_PAGE_NAT_NETWORK_CONF_RESULT_CODE=$DPLY_PAGE_NAT_NETWORK_CONF_RESULT_ERROR
        DPLY_PAGE_NAT_NETWORK_CONF_RESULT_ROLLING=0
        DPLY_PAGE_NAT_NETWORK_CONF_RESULT_MSG="${DPLY_PAGE_NAT_NETWORK_CONF_ERROR_APPLY_NETWORK_CONF}: ${UTILITY_APPLY_NAT_NETWORK_CONF_RESULT_MSG}"
        return
    fi
    

    # save to database
    RT_NAT_IP="${UTILITY_APPLY_NAT_NETWORK_CONF_RESULT_IP}"
    RT_NAT_NETMASK="${UTILITY_APPLY_NAT_NETWORK_CONF_RESULT_NETMASK}"
    RT_NAT_GATEWAY="${UTILITY_APPLY_NAT_NETWORK_CONF_RESULT_GATEWAY}"
    RT_NAT_DNS="${UTILITY_APPLY_NAT_NETWORK_CONF_RESULT_DNS}"
    utility_save_nat_network_conf \
        "${RT_NAT_DHCP}" \
        "${RT_NAT_IP}" \
        "${RT_NAT_NETMASK}" \
        "${RT_NAT_GATEWAY}" \
        "${RT_NAT_DNS}"
    if [ "${?}" -ne 0 ]; then
        DPLY_PAGE_NAT_NETWORK_CONF_RESULT_CODE=$DPLY_PAGE_NAT_NETWORK_CONF_RESULT_ERROR
        DPLY_PAGE_NAT_NETWORK_CONF_RESULT_ROLLING=0
        DPLY_PAGE_NAT_NETWORK_CONF_RESULT_MSG="${DPLY_PAGE_NAT_NETWORK_CONF_ERROR_SAVE_CONFIGURATION}: ${UTILITY_SAVE_NAT_NETWORK_CONF_RESULT_MSG}"
        return
    fi
    
    DPLY_PAGE_NAT_NETWORK_CONF_RESULT_CODE=$DPLY_PAGE_NAT_NETWORK_CONF_RESULT_OK
    DPLY_PAGE_NAT_NETWORK_CONF_RESULT_ROLLING=1
    DPLY_PAGE_NAT_NETWORK_CONF_RESULT_MSG=""
}
